/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.BaseComboBoxUI;
import com.jtattoo.plaf.NoFocusButton;
import com.jtattoo.plaf.hifi.HiFiIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;

public class HiFiComboBoxUI
extends BaseComboBoxUI {
    public static ComponentUI createUI(JComponent c2) {
        return new HiFiComboBoxUI();
    }

    public JButton createArrowButton() {
        NoFocusButton button = new NoFocusButton(HiFiIcons.getComboBoxIcon());
        button.setBorder(new ArrowButtonBorder());
        return button;
    }

    protected void setButtonBorder() {
    }

    static class ArrowButtonBorder
    extends AbstractBorder {
        private static final Insets insets = new Insets(1, 3, 1, 2);
        private static final Color frameLoColor = new Color(120, 120, 120);
        private static final Color frameLowerColor = new Color(104, 104, 104);
        private static final Color frameLowerLoColor = new Color(64, 64, 64);
        private static final Color frameLowestColor = new Color(32, 32, 32);

        ArrowButtonBorder() {
        }

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            Graphics2D g2D = (Graphics2D)g2;
            g2.translate(x, y);
            g2.setColor(frameLoColor);
            g2.drawLine(1, 0, w - 1, 0);
            g2.drawLine(1, 1, 1, h2 - 2);
            g2.setColor(frameLowerColor);
            g2.drawLine(w - 1, 1, w - 1, h2 - 2);
            g2.drawLine(2, h2 - 1, w - 2, h2 - 1);
            Composite composite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2D.setComposite(alpha);
            g2.setColor(frameLowestColor);
            g2.drawLine(2, 1, w - 2, 1);
            g2.drawLine(2, 2, 2, h2 - 3);
            g2.setColor(frameLowerLoColor);
            g2.drawLine(0, 0, 0, h2);
            g2D.setComposite(composite);
            g2.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(ArrowButtonBorder.insets.top, ArrowButtonBorder.insets.left, ArrowButtonBorder.insets.bottom, ArrowButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ArrowButtonBorder.insets.left;
            borderInsets.top = ArrowButtonBorder.insets.top;
            borderInsets.right = ArrowButtonBorder.insets.right;
            borderInsets.bottom = ArrowButtonBorder.insets.bottom;
            return borderInsets;
        }
    }
}

